#ifndef SST_SEP_ATP_INITTERMINATE_H
#define SST_SEP_ATP_INITTERMINATE_H

#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   : Apr 01 12:06:34 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_ATP_InitTerminate.h#1:incl:1
   *  \author  taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/*****************************************************************************
 * Function Name:
 *    SEPQA_SST_InitTerminate_1
 * 
* Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 *   Verify that init and terminate commands work
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    5.  Insert a new data object by calling: SST_InsertData.
 *    6.  Close the transaction by calling: SST_TransactionEnd.
 *    7.  Delete the session by calling: SST_SessionDelete.
 *******************************************************************************/  
DxError_t SEPQA_SST_InitTerminate_1 ( void );

/*****************************************************************************
 * Function Name:
 *    SEPQA_SST_InitTerminate_2
 * 
* Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 *   Verify that init and terminate commands work
 *  
 * Algorithm:
 
  *   1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    3.  Read and compare the inserted data by calling: SST_ReadData.
 *    4.  Delete the session by calling: SST_SessionDelete.
 *******************************************************************************/  
DxError_t SEPQA_SST_InitTerminate_2 ( void );

#ifdef __cplusplus
}


#endif

#endif
